package com.jianLing.demo.vo;


import java.util.StringJoiner;

/**
 * 查单响应vo
 */
public class QueryOrderResp {

    /** 响应内容 */
    private ResponseContent responseContent;
    /** 签名 */
    private String sign;

    public ResponseContent getResponseContent() {
        return responseContent;
    }

    public void setResponseContent(ResponseContent responseContent) {
        this.responseContent = responseContent;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", QueryOrderResp.class.getSimpleName() + "[", "]")
                .add("responseContent=" + responseContent)
                .add("sign='" + sign + "'")
                .toString();
    }

    /**
     * 下单响应实体
     */
    public static class ResponseContent {
        /** 状态码 */
        private Integer code;
        /** 状态信息 */
        private String msg;
        /** 响应时间 */
        private String timestamp;

        /** 系统订单号 */
        private String orderNo;
        /** 商户号 */
        private String merchno;
        /** 商户订单号 */
        private String orderId;
        /** 订单金额（元） */
        private String amount;
        /** 收款账户 */
        private String account;
        /** 交易类型(1：对私；2：对公) */
        private Integer tradeType;
        /** 银行卡号 */
        private String cardNo;
        /** 银行编码 */
        private String bankCode;
        /** 所属银行 */
        private String bankName;
        /** 开户行 */
        private String depositBank;
        /** 商户附加信息 */
        private String attach;
        /** 订单状态（1：已受理；2：已出款，未回调成功；3：成功;4：出款失败） */
        private Integer status;
        /** 请求货币（1：人民币；2：USDT；3：越南盾；4：印度卢比） */
        private Integer requestCurrency;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getOrderNo() {
            return orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getMerchno() {
            return merchno;
        }

        public void setMerchno(String merchno) {
            this.merchno = merchno;
        }

        public String getOrderId() {
            return orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getAmount() {
            return amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }

        public String getAccount() {
            return account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public Integer getTradeType() {
            return tradeType;
        }

        public void setTradeType(Integer tradeType) {
            this.tradeType = tradeType;
        }

        public String getCardNo() {
            return cardNo;
        }

        public void setCardNo(String cardNo) {
            this.cardNo = cardNo;
        }

        public String getBankCode() {
            return bankCode;
        }

        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        public String getBankName() {
            return bankName;
        }

        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        public String getDepositBank() {
            return depositBank;
        }

        public void setDepositBank(String depositBank) {
            this.depositBank = depositBank;
        }

        public String getAttach() {
            return attach;
        }

        public void setAttach(String attach) {
            this.attach = attach;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getRequestCurrency() {
            return requestCurrency;
        }

        public void setRequestCurrency(Integer requestCurrency) {
            this.requestCurrency = requestCurrency;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", ResponseContent.class.getSimpleName() + "[", "]")
                    .add("code=" + code)
                    .add("msg='" + msg + "'")
                    .add("timestamp='" + timestamp + "'")
                    .add("orderNo='" + orderNo + "'")
                    .add("merchno='" + merchno + "'")
                    .add("orderId='" + orderId + "'")
                    .add("amount='" + amount + "'")
                    .add("account='" + account + "'")
                    .add("tradeType=" + tradeType)
                    .add("cardNo='" + cardNo + "'")
                    .add("bankCode='" + bankCode + "'")
                    .add("bankName='" + bankName + "'")
                    .add("depositBank='" + depositBank + "'")
                    .add("attach='" + attach + "'")
                    .add("status=" + status)
                    .add("requestCurrency=" + requestCurrency)
                    .toString();
        }
    }
}
