package com.jianLing.demo.vo;


import java.math.BigDecimal;
import java.util.StringJoiner;

/**
 * 下单参数vo
 */
public class PlaceOrderParam {

    /** 订单金额（元） */
    private BigDecimal amount;
    /** 收款账户 */
    private String account;
    /** 交易类型(1：对私；2：对公) */
    private String tradeType;
    /** 银行卡号 */
    private String cardNo;
    /** 银行编码 */
    private String bankCode;
    /** 银行名称 */
    private String bankName;
    /** 开户行 */
    private String depositBank;
    /** 异步回调地址 */
    private String asyncUrl;
    /** 商户附加信息 */
    private String attach;
    /** 下发类型（1：人民币；2：USDT；3：越南盾；4：印度卢比） */
    private String cashType;
    /** 请求货币（1：人民币；2：USDT；3：越南盾；4：印度卢比） */
    private String requestCurrency;
    /** api接口版本 */
    private String apiVersion;


    public BigDecimal getAmount() {
        return amount;
    }

    public PlaceOrderParam setAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public String getAccount() {
        return account;
    }

    public PlaceOrderParam setAccount(String account) {
        this.account = account;
        return this;
    }

    public String getTradeType() {
        return tradeType;
    }

    public PlaceOrderParam setTradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    public String getCardNo() {
        return cardNo;
    }

    public PlaceOrderParam setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public String getBankCode() {
        return bankCode;
    }

    public PlaceOrderParam setBankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    public String getBankName() {
        return bankName;
    }

    public PlaceOrderParam setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public String getDepositBank() {
        return depositBank;
    }

    public PlaceOrderParam setDepositBank(String depositBank) {
        this.depositBank = depositBank;
        return this;
    }

    public String getAsyncUrl() {
        return asyncUrl;
    }

    public PlaceOrderParam setAsyncUrl(String asyncUrl) {
        this.asyncUrl = asyncUrl;
        return this;
    }

    public String getAttach() {
        return attach;
    }

    public PlaceOrderParam setAttach(String attach) {
        this.attach = attach;
        return this;
    }

    public String getCashType() {
        return cashType;
    }

    public void setCashType(String cashType) {
        this.cashType = cashType;
    }

    public String getRequestCurrency() {
        return requestCurrency;
    }

    public void setRequestCurrency(String requestCurrency) {
        this.requestCurrency = requestCurrency;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PlaceOrderParam.class.getSimpleName() + "[", "]")
                .add("amount='" + amount + "'")
                .add("account='" + account + "'")
                .add("tradeType='" + tradeType + "'")
                .add("cardNo='" + cardNo + "'")
                .add("bankCode='" + bankCode + "'")
                .add("bankName='" + bankName + "'")
                .add("depositBank='" + depositBank + "'")
                .add("asyncUrl='" + asyncUrl + "'")
                .add("attach='" + attach + "'")
                .add("cashType='" + cashType + "'")
                .add("requestCurrency='" + requestCurrency + "'")
                .add("apiVersion='" + apiVersion + "'")
                .toString();
    }
}
