package com.jianLing.demo.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * JSON解析处理
 * 
 * @author ruoyi
 */
public class JsonUtil
{
    public static final String DEFAULT_FAIL = "\"Parse failed\"";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();

    public static void marshal(File file, Object value)
    {
        try
        {
            objectWriter.writeValue(file, value);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static void marshal(OutputStream os, Object value)
    {
        try
        {
            objectWriter.writeValue(os, value);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static String marshal(Object value)
    {
        try
        {
            return objectWriter.writeValueAsString(value);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static byte[] marshalBytes(Object value)
    {
        try
        {
            return objectWriter.writeValueAsBytes(value);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unmarshal(File file, Class<T> valueType)
    {
        try
        {
            return objectMapper.readValue(file, valueType);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> valueType)
    {
        try
        {
            return objectMapper.readValue(is, valueType);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> valueType)
    {
        try
        {
            return objectMapper.readValue(str, valueType);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unmarshal(byte[] bytes, Class<T> valueType)
    {
        try
        {
            if (bytes == null)
            {
                bytes = new byte[0];
            }
            return objectMapper.readValue(bytes, 0, bytes.length, valueType);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }
}
